program LEASTSQUARESLINE;
{--------------------------------------------------------------------}
{  Alg5'1.pas   Pascal program for implementing Algorithm 5.1        }
{                                                                    }
{  NUMERICAL METHODS: Pascal Programs, (c) John H. Mathews 1995      }
{  To accompany the text:                                            }
{  NUMERICAL METHODS for Math., Science & Engineering, 2nd Ed, 1992  }
{  Prentice Hall, Englewood Cliffs, New Jersey, 07632, U.S.A.        }
{  Prentice Hall, Inc.; USA, Canada, Mexico ISBN 0-13-624990-6       }
{  Prentice Hall, International Editions:   ISBN 0-13-625047-5       }
{  This free software is compliments of the author.                  }
{  E-mail address:       in%"mathews@fullerton.edu"                  }
{                                                                    }
{  Algorithm 5.1 (Least Squares Line).                               }
{  Section   5.1, Least-Squares Line, Page 264                       }
{--------------------------------------------------------------------}

  uses
    crt;

  const
    GNmax = 130;
    MaxN = 100;

  type
    VECTOR = array[0..MaxN] of REAL;
    RVECTOR = array[0..GNmax] of REAL;
    LETTER = string[1];
    Status = (Computing, Done, More, Working);
    DATYPE = (DatPoints, FunPoints);
    ABTYPE = (Given, Equal, Interval, Chebyshev);
    DoSome = (Go, Stop);
    LETTERS = string[200];

  var
    DNpts, GNpts, Inum, N, Ctype, Sub: INTEGER;
    A, B, C, D, E2, L, Rnum, Xmax, Xmin, Ymax, Ymin: REAL;
    X, Y: VECTOR;
    Xg, Yg: RVECTOR;
    ANS: LETTER;
    Stat, State: Status;
    Ytype: DATYPE;
    Xtype: ABTYPE;
    DoMo: DoSome;
    Mess: LETTERS;

  procedure REGRESSION (X, Y: VECTOR; N: INTEGER; var A, B, E2: REAL);
    var
      K: INTEGER;
      Err, Xmean, Ymean, SumX, SumXY, z: REAL;
  begin
    Xmean := 0;
    for K := 1 to N do
      Xmean := Xmean + X[K];
    Xmean := Xmean / N;
    Ymean := 0;
    for K := 1 to N do
      Ymean := Ymean + Y[K];
    Ymean := Ymean / N;
    SumX := 0;
    for K := 1 to N do
      SumX := SumX + (X[K] - Xmean) * (X[K] - Xmean);
    SumXY := 0;
    for K := 1 to N do
      SumXY := SumXY + (X[K] - Xmean) * (Y[K] - Ymean);
    A := SumXY / SumX;
    B := Ymean - A * Xmean;
    E2 := 0;
    for K := 1 to N do
      begin
        Z := A * X[K] + B;
        Err := Y[K] - Z;
        E2 := E2 + Err * Err
      end;
    E2 := SQRT(E2 / N);
  end;

  function F (X: REAL): REAL;
  begin
    F := A * X + B;
  end;

  procedure INPUTS (var X, Y: VECTOR; var N: integer);
    var
      K: integer;
  begin
    CLRSCR;
    WRITELN;
    WRITELN('     The least squares line   Y  =  A x + B   that fits the');
    WRITELN;
    WRITELN('     data points (x ,y ) , (x ,y ) ,..., (x ,y ) will be found.');
    WRITELN('                   1  1      2  2          N  N ');
    WRITELN;
    Mess := '     Enter number of points N = ';
    N := 2;
    WRITE(Mess);
    READLN(N);
    if N < 2 then
      N := 2;
    if N > 100 then
      N := 100;
  end;

  procedure GETPOINTS (var X, Y: VECTOR; var Xmin, Xmax: real; var N: integer; Stat: STATUS);
    type
      STATUS = (Bad, Enter, Done);
      LETTER = string[1];
    var
      Count, I, J, K, Kbad: integer;
      T, Valu: real;
      Resp: LETTER;
      Cond: STATUS;
  begin
    CLRSCR;
    Kbad := -1;
    State := Working;
    if Stat = More then
      begin
        for I := 1 to 6 do
          WRITELN;
        WRITE('Do you want to enter  new data points ?  <Y/N>  ');
        Resp := 'N';
        READLN(Resp);
        if (Resp = 'Y') or (Resp = 'y') then
          begin
            Stat := Working;
            CLRSCR;
          end;
      end;
    if (Stat = Working) then
      begin
        CLRSCR;
        Kbad := 0;
        for K := 1 to N do
          begin
            X[K] := 0;
            Y[K] := 0;
          end;
        CLRSCR;
        WRITELN;
        WRITELN('              Now enter the ', N : 2, ' points.');
        WRITELN;
        WRITELN('          You will have a chance to make changes at the end.');
        WRITELN;
        WRITELN;
        Xtype := Given;
        for K := 1 to N do
          begin
            if Xtype = Given then
              begin
                WRITELN;
                Mess := '         x';
                WRITE(Mess, K : 1, ' = ');
                READLN(X[K]);
              end;
            Ytype := DatPoints;
            if Ytype = DatPoints then
              begin
                if Xtype <> Given then
                  begin
                    WRITELN;
                    WRITELN('         x  =', X[K] : 15 : 7);
                    WRITE('          ', K : 0);
                  end;
                WRITELN;
                Mess := '         y';
                WRITE(Mess, K : 1, ' = ');
                READLN(Y[K]);
                WRITELN;
              end
            else
              begin
            {Y[K]:=F(X[K]); Provision for function values.}
              end;
            WRITELN;
          end;
      end;
    Xmin := X[1];
    Ymin := Y[1];
    for K := 1 to N do
      begin
        if (Xmin > X[K]) then
          Xmin := X[K];
        if (Ymin > Y[K]) then
          Ymin := Y[K];
      end;
    Cond := Enter;
    while (Cond = Enter) or (Cond = Bad) do
      begin
        CLRSCR;
        if (Cond = Bad) then
          WRITELN('     The abscissas are NOT distinct.   You MUST change one of them.');
        WRITELN('      k               x                     y');
        WRITELN('                       k                     k');
        WRITELN('----------------------------------------------------------------');
        for K := 1 to N do
          WRITELN('     ', K : 2, '       ', X[K] : 15 : 7, '       ', Y[K] : 15 : 7);
        WRITELN;
        if (Cond <> Bad) then
          begin
            WRITELN;
            if N > 15 then
              begin
                WRITELN;
              end;
            WRITE('     Are the points o.k. ?  <Y/N>  ');
            Resp := 'Y';
            READLN(Resp);
          end;
        if (Resp = 'N') or (Resp = 'n') or (Cond = Bad) then
          begin
            if N > 14 then
              begin
                WRITELN;
              end;
            WRITELN;
            WRITELN;
            case N of
              2: 
                WRITELN('     To change a point select  k = 1,2');
              3: 
                WRITELN('     To change a point select  k = 1,2,3');
              else
                WRITELN('     To change a point select  k = 1,2,...,', N : 2);
            end;
            Mess := '                       ENTER   k = ';
            K := Kbad;
            WRITE(Mess);
            READLN(K);
            if (1 <= K) and (K <= N) then
              begin
                WRITELN;
                if K < 10 then
                  begin
                    WRITELN('     Coordinates of the  current point  (x ,y )  are:');
                    WRITELN('                                          ', K : 1, '  ', k : 1);
                    WRITELN('     Old   x  =', X[K] : 15 : 7, '      Old   y  =', Y[K] : 15 : 7);
                    WRITELN('            ', K : 1, '                              ', K : 1);
                  end
                else
                  begin
                    WRITELN('     Coordinates of the current point  (x  ,y  )  are:');
                    WRITELN('                                         ', K : 2, '  ', k : 2);
                    WRITELN('     Old   x  =', X[K] : 15 : 7, '      Old   y  =', Y[K] : 15 : 7);
                    WRITELN('            ', K : 2, '                             ', K : 2);
                  end;
                Mess := '     NEW   x';
                WRITE(Mess, K : 1, ' = ');
                READLN(X[K]);
                Mess := '     NEW   y';
                WRITE(Mess, K : 1, ' = ');
                READLN(Y[K]);
              end;
          end
        else
          Cond := Done;
        for J := 1 to N - 1 do
          begin
            for K := J + 1 to N do
              if X[J] > X[K] then
                begin
                  T := X[J];
                  X[J] := X[K];
                  X[K] := T;
                  T := Y[J];
                  Y[J] := Y[K];
                  Y[K] := T;
                end;
          end;
        if (Cond = Bad) then
          Cond := Enter;
        Count := 0;
        for J := 2 to N do
          if (X[1] = X[J]) then
            Count := Count + 1;
        if Count = N - 1 then
          begin
            Kbad := N;
            Cond := Bad;
          end;
        Xmax := X[1];
        Xmin := X[1];
        Ymax := Y[1];
        Ymin := Y[1];
        for K := 1 to N do
          begin
            if (Xmax < X[K]) then
              Xmax := X[K];
            if (Xmin > X[K]) then
              Xmin := X[K];
            if (Ymax < Y[K]) then
              Ymax := Y[K];
            if (Ymin > Y[K]) then
              Ymin := Y[K];
          end;
      end;
  end;

  procedure RESULTS (X, Y: VECTOR; N: integer; A, B, E2: real);
    var
      K: integer;
      Err, Z: real;
  begin
    CLRSCR;
    WRITELN;
    WRITELN('The least squares line is  Y = A x + B, where:');
    WRITELN;
    WRITELN('A = ', A : 15 : 7, '     B = ', B : 15 : 7);
    WRITELN;
    WRITELN('    k       X             Y           A x +B        Error');
    WRITELN('             k             k             k');
    WRITELN('  -------------------------------------------------------------');
    for K := 1 to N do
      begin
        Z := A * X[K] + B;
        Err := Y[K] - Z;
        WRITELN(K : 5, X[K] : 12 : 5, Y[K] : 14 : 5, Z : 14 : 7, Err : 14 : 7);
      end;
    WRITELN;
    WRITELN('The R. M. S. error is  E  = ', E2 : 1 : 7);
    WRITE('                        2');
  end;

  procedure MESSAGE;
  begin
    CLRSCR;
    WRITELN('                          LEAST SQUARES LINE');
    WRITELN;
    WRITELN;
    WRITELN('          The least squares line   Y  =  A x + B   that fits the');
    WRITELN;
    WRITELN('     data points (x ,y ) , (x ,y ) ,..., (x ,y ) will be found.');
    WRITELN('                   1  1      2  2          N  N ');
    WRITELN;
    WRITELN('     The coefficients  A  and  B  minimize the error function E(A,B):');
    WRITELN;
    WRITELN('                     N ');
    WRITELN('                                         2  ');
    WRITELN('         E(A,B)  =  Sum ( A x  + B - y  ) . ');
    WRITELN('                             k        k     ');
    WRITELN('                    k=1');
    WRITELN;
    WRITELN('     The closeness of fit is measured by the Root-mean-square error  E  ');
    WRITELN('                                                                      2 ');
    WRITELN('                     N ');
    WRITELN('                  1                      2  1/2  ');
    WRITELN('         E   =  [ - Sum ( A x  + B - y  )  ]   . ');
    WRITELN('          2       N          k        k          ');
    WRITELN('                    k=1');
    WRITELN;
    WRITE('                          Press the <ENTER> key. ');
    READLN(Ans);
  end;

begin                                            {Begin Main Program}
  MESSAGE;
  Stat := Working;
  while Stat = Working do
    begin
      INPUTS(X, Y, N);
      GETPOINTS(X, Y, Xmin, Xmax, N, Stat);
      REGRESSION(X, Y, N, A, B, E2);
      RESULTS(X, Y, N, A, B, E2);
      WRITELN;
      WRITELN;
      WRITELN;
      WRITE('Want to run the program with new data ?  <Y/N>  ');
      READLN(Ans);
      if (Ans <> 'Y') and (Ans <> 'y') then
        Stat := Done;
    end;
end.                                            {End of Main Program}

